/*
Copyright 2008-2011 Broadcom Corporation

This program isthe proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modifiedor distributed pursuant to
the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License"). Except as set forth in an
Authorized License, Broadcom grants no license (express or implied), right to
use, or waiver of any kind with respect to the Software, and Broadcom expressly
reserves all rights in and to the Software and all intellectual property rights
therein. IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS
SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL
USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization, constitutes
   the valuable trade secrets of Broadcom, and you shall use all reasonable
   efforts to protect the confidentiality thereof, and to use this information
   only in connection with your use of Broadcom integrated circuit products.

2.TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWAREIS PROVIDED "AS IS" AND
   WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
   WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
   THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMSANY AND ALL IMPLIED WARRANTIES
   OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
   LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
   OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
   USE OR PERFORMANCE OF THE SOFTWARE.

3.TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
   LICENSORS BE LIABLE FOR(i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
   EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
   USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
   THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
   ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
   LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
   ANY LIMITED REMEDY.
*/

/** @ingroup N3
 * \file apfw_tr06_get_tone_info.h
 * \brief APFW_TR069_GET_TONE_INFO primitive
 *
 * This primitive is used to retrieve tone information between the local node
 * and a peer one, passed as a parameter of the request.
 */

#ifndef APFW_TR069_GET_TONE_INFO_
#define APFW_TR069_GET_TONE_INFO_

#include "../base_types.h"
#include "definitions.h"

typedef struct
{
  TU16 AvgAttenuation; //!< Average attenuation from this remote device (expressed in 0.1dB).
  TU8  SNRPerTone[1155]; //!< Signal to Noise Ratio (SNR) from remote device (expressed in 0.25dB).
} tS_APFW_TR069_GET_TONE_INFO_CNF;

/** @ingroup N3
   \brief This is the struct to hold the transaction response.
*/
typedef struct
{
  tE_TransactionResult            result;   //!< Transaction result
  tS_APL2C_ERROR_CNF              err;      //!< APL2C_ERROR_CNF
  tS_APFW_TR069_GET_TONE_INFO_CNF cnf;      //!< APFW_TR069_GET_TONE_INFO.CNF
} tS_APFW_TR069_GET_TONE_INFO_Result;

/** @ingroup N3
   \brief Execute APFW_TR069_GET_TONE_INFO

   \param remote_device  Remote node's MAC Address
   \param result         Transaction result.
*/
void Exec_APFW_TR069_GET_TONE_INFO(t_MACaddr remote_device,
                                   tS_APFW_TR069_GET_TONE_INFO_Result *result);

#endif /*APFW_TR069_GET_TONE_INFO_*/




